﻿using System;
using System.Collections.Generic;
using System.Text;
using System.IO;
using System.Xml.Serialization;
using System.Drawing;
using System.Windows.Forms;

namespace Azyobuzi.りすにんぐついったー
{
    //個人的にXMLが好きなので
    //http://www.k4.dion.ne.jp/~anis7742/codevault/00080.html のパクリw
    public sealed class SettingsXml
    {
        private const string settingsFilaPath = ".\\settings.xml";
        private SettingsXml() { }

        #region 設定項目
        public uint interval = 60u;
            public string template ="listening: %0 / %1 #TwitMusic";
            public string accessToken;
            public string accessTokenSecret;
            public Rectangle bouds =new Rectangle(Screen.PrimaryScreen.WorkingArea.Location, new Size(364, 156));
            public bool auto = true;
        #endregion

        private static SettingsXml instance;
        public static SettingsXml Instance
        {
            get
            {
                if (instance == null)
                {
                    if (File.Exists(settingsFilaPath)) {
                        try {
                            using (StreamReader sr = new StreamReader(settingsFilaPath)) {
                                XmlSerializer xs = new XmlSerializer(typeof(SettingsXml));
                                instance = (SettingsXml)xs.Deserialize(sr);
                                sr.Close();
                                if (instance == null) { //不正なXMLをデシリアライズするとnullが返ることがある。
                                    throw new Exception();
                                }
                            }
                        } catch {
                            MessageBox.Show("設定ファイルが不正です。設定を初期化します。", "エラー", MessageBoxButtons.OK, MessageBoxIcon.Warning);
                            File.Copy(settingsFilaPath, settingsFilaPath + ".backup", true);
                            instance = new SettingsXml();
                        }
                    } else {
                        instance = new SettingsXml();
                    }
                }

                return instance;
            }
        }

        public static void Save()
        {
            using (StreamWriter sw = new StreamWriter(settingsFilaPath))
            {
                XmlSerializer xs = new XmlSerializer(typeof(SettingsXml));
                xs.Serialize(sw, Instance);
                sw.Close();
            }
        }
    }
}
